import java.awt.Frame;
import java.awt.Button;
import java.awt.Panel;
import java.awt.Scrollbar;
import graphics.Slider; 
import java.awt.Label;
import java.awt.Font;
import java.awt.Event;
import java.awt.TextArea;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Graphics;
import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.Math;
import types.DataClass;

public class SenderPanel extends MenuPanel {
	public Computer	  		m_Computer;
	public WheelInfoPanel	m_swPanel;
	public WheelInfoPanel	m_rwPanel;
	public BucketPanel      m_Buffer;
	protected TextArea      m_Message;
	public SenderPanel(Computer computer)	{
		super();
		m_Computer = computer;
		// create property dialog
		m_Dlg = Global.m_dlgComputerProperties;

		setLayout(new BorderLayout(15,15));
		ImagePanel ci =	new	ImagePanel(m_Computer.m_Image);
		SenderControl cp	= new SenderControl(m_Computer);
		m_swPanel =	new	WheelInfoPanel(m_Computer.protocol().sendWindow);
		m_Buffer = new BucketPanel(m_Computer.protocol().m_Buffer1,40,50);
		m_Message = new TextArea(2,10);
        m_Message.setText(m_Computer.m_SendPool.toString());
		add("Center",ci);
		add("South",cp);
		add("West",m_swPanel);
        Panel p = new Panel();
        p.setLayout(new BorderLayout(0,20));
        p.add("Center",m_Buffer);
        p.add("North",new Label("Buffer",Label.LEFT));
        add("East",p);
        add("North",m_Message);
	}
	public void	paint(Graphics g) {
		Rectangle frame=bounds();
	}
	public void	redisplay(DataClass	sw,DataClass rw) {
		m_swPanel.myUpdate(sw);
		m_Buffer.myUpdate(m_Computer.protocol().m_Buffer1);
		m_Message.select(0,m_Computer.m_iSendIndex);
	}
	public boolean handleEvent(Event event) {
	    switch (event.id) {
        case Event.KEY_PRESS:
            if (event.target==m_Message) {
                m_Computer.setData(m_Message.getText());
            }
            break;
        }
        return(super.handleEvent(event));
    }
}

class SenderSlider	extends	Slider {
	Computer	m_Computer;
	int			m_iOldValue;
	public SenderSlider(Computer computer)	{
		m_Computer = computer;
		m_iOldValue	= 0;
	}
	protected void Motion()	{
		m_Computer.setSpeed(GetValue());
	}
}


class SenderControl extends Panel {
	Computer	m_Computer;
	Button		m_nextStep;
	SenderSlider m_ControlSlider;
	public SenderControl(Computer computer) {
		m_Computer = computer;
		// use GridbagLayoutmanager
		GridBagLayout gbl =	new	GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();
		setLayout(gbl);
		// ####### Insert first	row	#######
		// Create Objects
		m_nextStep = new Button("Step");
		m_ControlSlider	= new SenderSlider(m_Computer);
		m_ControlSlider.SetHeight(30);
		m_ControlSlider.SetWidth(100);
		m_ControlSlider.SetMinimum(0);
		m_ControlSlider.SetMaximum(100);
		m_ControlSlider.SetValue(0);
		ImagePanel imgPanel	= new ImagePanel(Global.m_imgSendSpeed);
		// Set layout of Objects
		// Image
		gbc.anchor = GridBagConstraints.CENTER;
		gbc.insets = new Insets(0,0,0,0);
		gbc.gridwidth =	1;
		gbc.fill = GridBagConstraints.NONE;
		gbl.setConstraints(imgPanel,gbc);
		add(imgPanel);
		// Slider
		gbc.insets = new Insets(0,5,0,5);
		gbc.gridwidth =	1;
		gbc.fill = GridBagConstraints.NONE;
		gbl.setConstraints(m_ControlSlider,gbc);
		add(m_ControlSlider);
		// Button
		gbc.insets = new Insets(0,0,0,0);
		gbc.gridwidth =	GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.NONE;
		gbl.setConstraints(m_nextStep,gbc);
		add(m_nextStep);
	}
	public boolean action(Event e,Object what)	{
		if ((e.target == m_nextStep)) {
			if (m_ControlSlider.GetValue()==0) {
			    m_Computer.upperLayerSend();
			}
		}
    	return(true);
	}
}

